﻿Partial Public Class SecondPage
    Inherits PhoneApplicationPage
    Private rand As New Random()


    Public Sub New()
        InitializeComponent()
    End Sub


    Private Sub OnTextBlockManipulationStarted(ByVal sender As Object,
                                               ByVal args As ManipulationStartedEventArgs)
        Me.NavigationService.GoBack()

        args.Complete()
        args.Handled = True
    End Sub


    Protected Overrides Sub OnManipulationStarted(ByVal args As ManipulationStartedEventArgs)
        ContentPanel.Background = New SolidColorBrush(Color.FromArgb(255, CByte(rand.Next(255)),
                                                                          CByte(rand.Next(255)),
                                                                          CByte(rand.Next(255))))

        MyBase.OnManipulationStarted(args)
    End Sub


    Protected Overrides Sub OnNavigatedTo(ByVal args As NavigationEventArgs)
        Dim parameters As IDictionary(Of String, String) = Me.NavigationContext.QueryString

        If parameters.ContainsKey("Red") Then
            Dim R = Byte.Parse(parameters("Red"))
            Dim G = Byte.Parse(parameters("Green"))
            Dim B = Byte.Parse(parameters("Blue"))

            ContentPanel.Background = New SolidColorBrush(Color.FromArgb(255, R, G, B))
        End If

        MyBase.OnNavigatedTo(args)
    End Sub
End Class